/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBModuleTimeline = Object.create(STBModule.prototype);
STBModuleTimeline.name="ModuleTimeline";

STBModuleTimeline.initModule = function() {

	var timeline = $(".timeline");

	if (timeline.length) {

		var parseTimeline = function () {
			var obj = $(this),
				cnt = 1,
				item = obj.find(".timeline-item:not(.__done)"),
				last = obj.find(".timeline-item.__done").last(),
				next = "left";

			if (item.length > 0) {

				if (last.length) {
					if (last.hasClass("left")) {
						next = "right";
					} else {
						next = "left"
					}
				}

				var parseItem = function () {
					var inObj = $(this);

					inObj.addClass(next);
					next = next == "left" ? "right" : "left";

					inObj.addClass("__done");
				};

				item.each(parseItem);
			}

			obj.data("data-last", cnt);

		};

		timeline.each(parseTimeline);
	}

}

STBModuleTimeline.loadMoreItems = function() {
    try {
        var timelineAjaxForm = false,
            timeline = $(".timeline:not(.__done_more)");

  

        var onMore = function (e) {
            var obj = $(this),
                parent = obj.closest(".module-timeline").find(".timeline");

			e.preventDefault();

            if (obj.hasClass("__working")) {
                //// ???
            } else {
                obj.addClass("__working");

                timelineAjaxForm = $.ajax(
                    {
                        url: parent.attr("data-url"),
                        type: "post",
                        data: "page=" + (parseInt(parent.attr("data-page")) + 1)
                    }
                ).done( function (msg) {

                    timelineAjaxForm = false;

                    if (msg != "") {

						//replace the bgscheme
						msg = STBUtils.bgSchemeReplace(msg , timeline.attr("data-scheme"));

                        var elements = $(msg),
                            cnt = parent.data("data-last"),
                            timelineContent = parent.find('.timeline-content'),
                            timelineItem = timelineContent.find(".timeline-item");

                        parent.attr("data-page", parseInt(parent.attr("data-page")) + 1);
                        timelineContent.append(elements);                        
                        parent.data("data-last", cnt);

						site.runOnContentUpdate();

                    } else {
                        parent.find(".load-more button").remove();
                    }

                    obj.removeClass("__working");
                });
            }
        };

        $(".load-more", ".module-timeline").find('button').on('click', onMore);



    } catch (e) {
        getStack(0, e);
    }
};


STBModuleTimeline.runOnContentUpdate = function() {
	STBModuleTimeline.initModule();
	STBModuleTimeline.loadMoreItems();
}

STBModuleTimeline.runOnReady = function() {
	STBModuleTimeline.initModule();
	STBModuleTimeline.loadMoreItems();
}

site.registerModule(STBModuleTimeline);